import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';

import { MccfDataModule } from '../mccf-data/mccf-data.module';

import { routing } from './mccf-common.routing';
import { SpellCheckComponent } from './spellcheck/spellcheck.component';
import { AdminMenusComponent } from './admin-menus/admin-menus.component';
import { FhirSearchComponent } from './fhir-search/fhir-search.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { PractitionerComponent } from './fhir-search/practitioner/practitioner.component';
import { TreatmentFacilityComponent } from './fhir-search/treatment-facility/treatment-facility.component';
import { PatientComponent } from './fhir-search/patient/patient.component';
import { LoggerComponent } from './logger/logger.component';
import { LogTypePipe } from './logger/type.pipe';
import { NgxDatatableModule } from '@swimlane/ngx-datatable';
import { FaqComponent } from './faq/faq.component';
import { HelpComponent } from './help/help.component';
import { ContactComponent } from './contact/contact.component';
import { SearchResultsComponent } from './search-results/search-results.component';
import { FhirResourceComponent } from './fhir-resource/fhir-resource.component';
import { FhirOrganizationComponent } from './fhir-resource/organization/organization.component'
import { FhirPractitionerComponent } from './fhir-resource/practitioner/practitioner.component'
import { FhirPatientComponent } from './fhir-resource/patient/patient.component';
import { FhirConditionComponent } from './fhir-resource/condition/condition.component';
import { FhirFindComponent } from './fhir-resource/find/find.component'
import { LinkComponent } from './link/link.component'

@NgModule({
    imports: [
    CommonModule,
    MccfDataModule,
    routing,
    FormsModule,
    ReactiveFormsModule,
    NgxDatatableModule
    ],
    declarations: [
    SpellCheckComponent,
    AdminMenusComponent,
    FhirSearchComponent,
    PractitionerComponent,
    TreatmentFacilityComponent,
    PatientComponent,
    LoggerComponent,
    LogTypePipe,
    FaqComponent,
    HelpComponent,
    ContactComponent,
    SearchResultsComponent,
    FhirResourceComponent,
    FhirOrganizationComponent,
    FhirPractitionerComponent,
    FhirPatientComponent,
    FhirConditionComponent,
    FhirFindComponent,
    LinkComponent
  ],
  exports: [
    LinkComponent
  ]
})
export class MccfCommonModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: CommonModule
    }
  }
}
